let score = 0;
const game = document.getElementById("game");
const windowWidth = window.innerWidth;
let time = 60;

setInterval(gameLoop, 1000);
function gameLoop() {
    time--;
}

const appearTarget = function (posX, posY, dur, isLeft) {




    // Create a new div element for the duck
const duck = document.createElement("div");
duck.setAttribute("class", "duck");
duck.style.top = `${posY}px`;
duck.style.left = `${posX}px`;
duck.addEventListener('click', function (e) {
    console.log('clicked');
    score++;
    e.target.remove();
    console.log(e);
    // Create a new audio element for the quack sound
    const ding = document.createElement("audio");
    ding.setAttribute("autoplay", "");
    ding.setAttribute("src", "quack_5.mp3");
    // Append the quack sound to the game element
    game.appendChild(ding);



    });
    game.appendChild(duck);
    console.log(isLeft);
    console.log(windowWidth);
    if (isLeft == true) {
        duck.setAttribute("class", "left duck");
        const animBox = duck.animate(
            [{ transform: `translateX(-200px)` },
            { transform: `translateX(${windowWidth + 200}px)` }],
            { duration: dur, easing: "linear" });
        animBox.onfinish = (function (e) {
            e.target.remove;
        });
    } else {
        duck.setAttribute("class", "right duck");
        const animBox = duck.animate(
            [{ transform: `translateX(0px)` },
            { transform: `translateX(-${windowWidth + 350}px)` }],
            { duration: dur, easing: "linear" });
        animBox.onfinish = (function (e) {
            e.target.remove;
        });
    }

};
const randomInt = function (min, max) {
    return Math.floor(Math.random() * (max - min) + min);
}

const gameEnd = function () {
    let currentstar = localStorage.getItem("lvl1stars");
    let newstar = 0;
    if (score >= 10 && score < 20) {
        newstar = 1;
    } else if (score >= 20 && score < 30) {
        newstar = 2;
    } else if (score >= 30) {
        newstar = 3;
    }

    if (newstar > currentstar) {
        localStorage.setItem("lvl1stars", newstar);
    }
    let currenthighscore = localStorage.getItem("lvl1highscore");
    if (score > currenthighscore) {
        localStorage.setItem("lvl1highscore", score);
    }
    localStorage.setItem("userscore", score);


    window.location.href = "lvl1endscreen.html";
}

// Initialize a variable fps to count the frames per second
let fps = 0;
// Get the game UI element by its ID and assign it to the gameUI constant
const gameUI = document.getElementById("gameUI");
// Define a function called gamerender which will be responsible for rendering the game
const gamerender = function () {
    // Increment the fps counter
    fps++;
// Update the text content of the game UI element to display the current time and score
    gameUI.textContent = `Time: ${time}     Score: ${score} `;
// If the fps counter exceeds 80, generate a new duck target with appearTarget function
    if (fps > 80) {
        // Generate a random number to determine if the duck will appear on the left or right side of the screen
        const negorpos = randomInt(1, 3);
        // Log the negorpos value to the console
        console.log(negorpos);
        // If negorpos is 1, call appearTarget function to create a duck on the left side of the screen
        if (negorpos == 1) {
            appearTarget(-200, randomInt(75, window), randomInt(4000, 6000), true);
        } else {
            // If negorpos is not 1, call appearTarget function to create a duck on the right side of the screen
            appearTarget(windowWidth + 100, randomInt(75, 500), randomInt(4000, 6000), false);
        }

        // Reset the fps counter to 0
        fps = 0;
    }
// If the time reaches 0, call the gameEnd function to end the game
    if (time == 0) {
        gameEnd();
    }
// Request the next animation frame to continuously render the game
    window.requestAnimationFrame(gamerender);
}
// Call the gamerender function to start rendering the game
window.requestAnimationFrame(gamerender);


