// Initialize variables for username, user score, counter, and an empty array to hold leaderboard data
let username = "";
let userscore = 0;
let i = 0;
let lb2 = [];

// Retrieve leaderboard data from localStorage and parse it into an array
lb2string = localStorage.getItem("lb2");
lb2 = JSON.parse(lb2string);

// Sort the lb2 array by score in descending order and store it in lb2s
lb2s = lb2.sort((a, b) => b.score - a.score);

// Function to insert leaderboard data into HTML table
function Insert_Data() {
    // Get reference to the HTML table element
    var table = document.getElementById("datas");
    // Clear table content
    table.innerHTML = "";
    var tr = "";
    // Iterate through each entry in lb2s array
    lb2s.forEach(x => {
        i++; //"i" represents the rank
        // Construct HTML row with rank, name, and score
        tr += '<tr>';
        tr += '<td>' + i + '</td>' + '<td>' + x.name + '</td>' + '<td>' + x.score + '</td>'
        tr += '</tr>'
    })
    // Append constructed HTML rows to the table
    table.innerHTML += tr;
}

// Get reference to the back button element and add event listener to navigate to "intromenu.html" on click
let backbutton = document.getElementById("back");
backbutton.addEventListener("click", function (e) { window.location.href = "intromenu.html"; })

// Get reference to the leaderboard button element and add event listener to navigate to "leaderboard.html" on click
let leaderboardbutton = document.getElementById("Lv1Leaderboard");
leaderboardbutton.addEventListener("click", function (e) { window.location.href = "leaderboard.html"; })

// Get reference to the lv3 leaderboard button element and add event listener to navigate to "lb3.html" on click
let lb3button = document.getElementById("lv3Leaderboard");
lb3button.addEventListener("click", function (e) { window.location.href = "lb3.html"; })


